<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fmp="http://www.filemaker.com/fmpxmlresult">
	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="no"/>
	<!--
File: custom_delim.xsl

Transforms data in FMPXMLRESULT grammar into a text file with the 
specified characters as field and record delimiters.

Note that it is possible to choose field and record delimiters 
that would result in an exported file that FileMaker Pro can no
longer import.

For example:

Database data
=============
White     Johnson  Red       33
Green     Mark     Red      100 
Blue      Sam      Blue     201 
Yellow    Susan    Green    839 
Straight  Wendy    Orange    22

Output
======
White*Johnson*Red*33
Green*Mark*Red*100 
Blue*Sam*Blue*201 
Yellow*Susan*Green*839 
Straight*Wendy*Orange*22
 
===============================================================

Copyright © 2002 FileMaker, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in 
  the documentation and/or other materials provided with the
  distribution.

* Neither the name of the FileMaker, Inc. nor the names of its 
  contributors may be used to endorse or promote products derived
  from this software without specific prior written
  permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
    
===============================================================
-->
	<xsl:template match="fmp:FMPXMLRESULT">
		<xsl:for-each select="fmp:RESULTSET/fmp:ROW">
			<xsl:for-each select="fmp:COL">
				<xsl:choose>
					<xsl:when test="position()=last()">
						<xsl:value-of select="fmp:DATA"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="fmp:DATA"/>
						<xsl:value-of select="$delimiter"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<xsl:value-of select="$newrecord"/>
		</xsl:for-each>
	</xsl:template>
	<!--  
Variable "delimiter" contains the character that will be inserted in the output
between each field in the exported data.
	        
Change the "*" between the "xsl:text" tags to make customizations.
	-->
	<xsl:variable name="delimiter">
		<xsl:text>*</xsl:text>
	</xsl:variable>
	<!--  
Variable "newline" contains the character that will be inserted in the output as the
end of record character.
	        
By default the new record delimitter is a carriage return. Other characters may be
inserted between the xsl:text tags to create different delimitters.
	-->
<xsl:variable name="newrecord">
<xsl:text>
</xsl:text>
</xsl:variable>
</xsl:stylesheet>
